/*
 * Basic responsive mashup template
 * @owner Enter you name here (xxx)
 */
/*
 *    Fill in host and port for Qlik engine
 */
var prefix = window.location.pathname.substr( 0, window.location.pathname.toLowerCase().lastIndexOf( "/extensions" ) + 1 );
var config = {
	host: window.location.hostname,
	prefix: prefix,
	port: window.location.port,
	isSecure: window.location.protocol === "https:"
};
require.config( {
	baseUrl: ( config.isSecure ? "https://" : "http://" ) + config.host + (config.port ? ":" + config.port : "") + config.prefix + "resources"
} );

require( ["js/qlik"], function ( qlik ) {
	qlik.setOnError( function ( error ) {
		$( '#popupText' ).append( error.message + "<br>" );
		$( '#popup' ).fadeIn( 1000 );
	} );
	$( "#closePopup" ).click( function () {
		$( '#popup' ).hide();
	} );

	$( ".create-viz" ).addClass( "lui-disabled" );

	$( ".section-3" ).click( function () {
		$( ".content-3" ).toggleClass( "show-section" );
	} );

	$( ".get-script" ).click( function () {
		var appId = $( ".app-id" ).val();
		app1 = qlik.openApp(appId, config);
		app1.getScript().then(function( script ){
			$( ".get-script-result" ).val( script.qScript );
			//console.log( script );
		});
	} );

	$( ".set-script" ).click( function () {
		$( ".msg-success" ).removeClass( "show" );
		$( ".msg-fail" ).removeClass( "show" );

		var script = $( ".set-script-input" ).val();
		var app2 = qlik.sessionApp(config);
		app2.setScript(script).then(function(){
			var stop = setInterval(function(){
				app2.global.getProgress(app2.model.handle).then(function(progress){
					//console.log("DoReload progress", progress);
				});
			}, 100);
			app2.doReload().then(function(result){
				if( result ){
					$( ".msg-success" ).addClass( "show" );
				} else {
					$( ".msg-fail" ).addClass( "show" );
				}

			}).finally(function(){
				clearInterval(stop);
			}).catch( function ( error ) {
				console.log( error );
			} );

			app2.getScript().then(function( script ){
				$( ".set-script-result" ).val( script.qScript );
			});
		});
	} );

	$( ".create-session-app" ).click( function () {
		var sessionApp = qlik.sessionApp(config);
		var script2 = "Characters: Load Chr(RecNo()+Ord('A')-1) as Alpha, RecNo() as Num autogenerate 26;   ASCII: Load   if(RecNo()>=65 and RecNo()<=90,RecNo()-64) as Num,  Chr(RecNo()) as AsciiAlpha,   RecNo() as AsciiNum autogenerate 255  Where (RecNo()>=32 and RecNo()<=126) or RecNo()>=160 ;   Transactions: Load  TransLineID,   TransID,  mod(TransID,26)+1 as Num,  Pick(Ceil(3*Rand1),'A','B','C') as Dim1,  Pick(Ceil(6*Rand1),'a','b','c','d','e','f') as Dim2,  Pick(Ceil(3*Rand()),'X','Y','Z') as Dim3,  Round(1000*Rand()*Rand()*Rand1) as Expression1,  Round(  10*Rand()*Rand()*Rand1) as Expression2,  Round(Rand()*Rand1,0.00001) as Expression3; Load   Rand() as Rand1,  IterNo() as TransLineID,  RecNo() as TransID Autogenerate 1000  While Rand()<=0.5 or IterNo()=1;  Comment Field Dim1 With 'This is a field comment';";

		//createdApp.getScript().then(function(script){
			sessionApp.setScript(script2).then(function(){
				var stop = setInterval(function(){
					sessionApp.global.getProgress(sessionApp.model.handle).then(function(progress){
						//console.log("DoReload progress", progress);
					});
				}, 100);
				sessionApp.doReload().then(function(result){

						sessionApp.visualization.create('barchart',["Dim1", "=Sum([Expression1])"],   {"title":"Session App - Bar Chart"}).then(function(vis){
							vis.show("QV01");
						});
						sessionApp.visualization.create('piechart',["Dim1", "=Count([Expression1])"],   {"title":"Session App - Pie Chart"}).then(function(vis){
							vis.show("QV02");
						});
						sessionApp.getObject('CurrentSelections','CurrentSelections');

						$( ".clear-all" ).click( function () {
							sessionApp.clearAll();
						} );

						$( ".step-forward" ).click( function () {
							sessionApp.forward();
						} );

						$( ".step-back" ).click( function () {
							sessionApp.back();
						} );

						$( ".lock-all" ).click( function () {
							sessionApp.lockAll();
						} );

				}).finally(function(){
					clearInterval(stop);
				}).catch( function ( error ) {
				console.log( error );
				});
			});
	} );
} );
